package fr.asip.cps3.exemple.modele.resultats;

import java.util.LinkedHashMap;

/**
 * Classe reprsentant le rsultat d'un traitement spcifique accompagn d'informations
 */
public class ResultatSpecifiqueInfo extends ResultatSpecifique {

	/**
	 * Map d'informations
	 */
	protected LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
	
	/**
	 * Constructeur
	 * @param traitement Description du traitement
	 */
	public ResultatSpecifiqueInfo(String traitement){
		super(traitement);
	}

	/**
	 * Accesseur
	 * @return La map d'informations
	 */
	public LinkedHashMap<String,String> getInfos() {
		return this.infos;
	}

	/**
	 * Mutateur
	 * @param infos Map d'informations
	 */
	public void setInfos(LinkedHashMap<String,String> infos) {
		this.infos = infos;
	}

}
